/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.RemovableMediaDevice;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.certs.StreamTracerThread;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

class CertUtils
implements CertMgtConstants {
    private static String hTTPDExecutable = null;
    private static final String SERVER_DELETE_CERT_COMMAND = "deleteCert";
    private static final String SERVER_USE_NEW_CERT_COMMAND = "installCert";
    private static final int MILLI_SECONDS_PER_DAY = 86400000;
    private static final String SSL_CERT_DIR = "sslCertDir";
    private static final String SSL_KEY_DIR = "sslKeyDir";
    private static final String TRACE_MASKD = "XCRTUTLD";
    private static final String TRACE_MASKF = "XCRTUTLF";
    private static final String TRACE_MASKT = "XCRTUTLT";

    private CertUtils() {
    }

    public static void main(String[] args) {
    }

    static void executeCommand(String command) throws HException {
        CertUtils.executeCommand(command, null);
    }

    static void executeCommand(String command, String[] env, boolean traceCommand) throws HException {
        Process tempProcess = null;
        try {
            if (env == null || env.length < 1) {
                if (traceCommand) {
                    Trace.trace(TRACE_MASKF, "Issuing command: " + command);
                }
                tempProcess = Runtime.getRuntime().exec(command);
            } else {
                if (traceCommand) {
                    Trace.trace(TRACE_MASKF, "Issuing command: " + command + " with environment variables:");
                    for (int i = 0; i < env.length; ++i) {
                        Trace.trace(TRACE_MASKF, env[i]);
                    }
                }
                tempProcess = Runtime.getRuntime().exec(command, env);
            }
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException: " + e.getMessage());
            throw new HException(e);
        }
        CertUtils.finishProcess(tempProcess, command, traceCommand);
    }

    static void executeCommand(String command, String[] env) throws HException {
        CertUtils.executeCommand(command, env, true);
    }

    private static void finishProcess(Process tempProcess, String command, boolean traceResult) throws HException {
        Thread thread = null;
        thread = new Thread(new StreamTracerThread(tempProcess.getInputStream(), "STDOUT"));
        thread.start();
        thread = new Thread(new StreamTracerThread(tempProcess.getErrorStream(), "STDERR"));
        thread.start();
        try {
            int rc = tempProcess.waitFor();
            if (traceResult) {
                Trace.trace(TRACE_MASKF, "The command, " + command + ", returned with an rc of " + rc + ".");
            }
            if (rc != 0) {
                if (traceResult) {
                    throw new HException("The command, " + command + ", returned with an rc of " + rc);
                }
                throw new HException("The command returned with an rc of " + rc);
            }
        }
        catch (InterruptedException e) {
            Trace.trace(TRACE_MASKF, "InterruptedException: " + e.getMessage());
            if (traceResult) {
                throw new HException("The command, " + command + ", was interrupted.");
            }
            throw new HException("The command was interrupted.");
        }
    }

    static String getFQFileName(String fileName) throws HException {
        return BaseFileControl.getFilePath(fileName) + fileName;
    }

    static void doExit(int status) {
        Trace.trace(TRACE_MASKD, "The main() method exiting with an exit status of " + status + ".");
        System.exit(status);
    }

    static boolean isIPAddress(String inString) {
        int firstPeriodIndex = 0;
        int secondPeriodIndex = 0;
        int thirdPeriodIndex = 0;
        int firstNum = 0;
        int secondNum = 0;
        int thirdNum = 0;
        int fourthNum = 0;
        try {
            firstPeriodIndex = inString.indexOf(46);
            if (firstPeriodIndex != -1 && (secondPeriodIndex = inString.indexOf(46, firstPeriodIndex + 1)) != -1 && (thirdPeriodIndex = inString.indexOf(46, secondPeriodIndex + 1)) != -1 && (firstNum = Integer.parseInt(inString.substring(0, firstPeriodIndex))) >= 0 && firstNum <= 255 && (secondNum = Integer.parseInt(inString.substring(firstPeriodIndex + 1, secondPeriodIndex))) >= 0 && secondNum <= 255 && (thirdNum = Integer.parseInt(inString.substring(secondPeriodIndex + 1, thirdPeriodIndex))) >= 0 && thirdNum <= 255 && (fourthNum = Integer.parseInt(inString.substring(thirdPeriodIndex + 1))) >= 0 && fourthNum <= 255) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    static X509Certificate createX509Certificate(String fileName) throws HException, FileNotFoundException {
        FileInputStream fis = null;
        CertificateFactory cf = null;
        X509Certificate cert = null;
        BufferedInputStream bis = null;
        fis = new FileInputStream(fileName);
        bis = new BufferedInputStream(fis);
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new HException(e);
        }
        try {
            if (bis.available() > 0) {
                cert = (X509Certificate)cf.generateCertificate(bis);
                if (bis.available() > 0) {
                    throw new HException("More than one certificate in the file, " + fileName);
                }
                return cert;
            }
            throw new HException("No certificate in the file, " + fileName);
        }
        catch (CertificateException e) {
            throw new HException(e);
        }
        catch (IOException e) {
            throw new HException(e);
        }
    }

    static String getConfiguredServerCertFileName() throws HException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath(SSL_CERT_DIR) + "server.crt";
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting server certificate file name : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        return result;
    }

    static String getConfiguredServerKeyFileName() throws HException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath(SSL_KEY_DIR) + "server.key";
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting server certificate file name : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        return result;
    }

    static String getConfiguredSigningChainFileName() throws HException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath(SSL_CERT_DIR) + "signing_chain.crts";
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting signing chain file name : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        return result;
    }

    static String getConfiguredArchivedServerCertFileName() throws HException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath(SSL_CERT_DIR) + "archived.server.crt";
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting archived server certificate file name : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        return result;
    }

    static String getConfiguredArchivedServerKeyFileName() throws HException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath(SSL_KEY_DIR) + "archived.server.key";
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting archived server key file name : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        return result;
    }

    static String getConfiguredArchivedSigningChainFileName() throws HException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath(SSL_CERT_DIR) + "archived.signing_chain.crts";
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting archived server key file name : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        return result;
    }

    static boolean isFullyQualifiedHostName(String hostName) {
        boolean result = false;
        int firstPeriodIndex = 0;
        int secondPeriodIndex = 0;
        Trace.trace(TRACE_MASKT, "->isFullyQualifiedHostName(" + hostName + ")");
        if (hostName != null && hostName.length() > 0 && (firstPeriodIndex = hostName.indexOf(46)) != -1 && firstPeriodIndex < hostName.length() - 1 && (secondPeriodIndex = hostName.indexOf(46, firstPeriodIndex)) != -1 && secondPeriodIndex < hostName.length() - 1) {
            result = true;
        }
        Trace.trace(TRACE_MASKT, "<-isFullyQualifiedHostName(" + hostName + ") returning " + result);
        return result;
    }

    static String getShortHostName(String hostName) {
        String result = null;
        int firstPeriodIndex = 0;
        Trace.trace(TRACE_MASKT, "->getShortHostName(" + hostName + ")");
        if (hostName != null && hostName.length() > 0 && (firstPeriodIndex = hostName.indexOf(46)) != -1) {
            result = hostName.substring(0, firstPeriodIndex);
        }
        Trace.trace(TRACE_MASKT, "<-getShortHostName(" + hostName + ") returning " + result);
        return result;
    }

    static HashSet addIPAddresses(HashSet inSet) {
        InetAddress localHost = null;
        String localHostText = null;
        HashSet result = null;
        Trace.trace(TRACE_MASKT, "->getIPAddresses(" + inSet + ")");
        result = inSet == null ? new HashSet() : (HashSet)inSet.clone();
        try {
            localHost = InetAddress.getLocalHost();
            if (localHost != null && (localHostText = localHost.getHostAddress()) != null && localHostText.length() > 0) {
                Trace.trace(TRACE_MASKD, "adding IP address of " + localHostText);
                result.add(localHostText);
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<-getIPAddresses() returning " + result);
        return result;
    }

    static synchronized void install(String fileName, String keyFileName, String chainingFileName) throws HException {
        String command = null;
        String hTTPDExecutable = null;
        String hTTPDPIDFile = null;
        String hMCSSLConfigFile = null;
        String hTTPDServerRoot = null;
        try {
            hTTPDExecutable = CertUtils.getFQFileName("httpd");
            hTTPDPIDFile = CertUtils.getFQFileName("httpd.pid");
            hMCSSLConfigFile = CertUtils.getFQFileName("hmc_ssl.conf");
            hTTPDServerRoot = BaseFileControl.getFilePath("httpdServerRootDir");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        command = "installCert " + fileName + " " + keyFileName + " " + CertUtils.getConfiguredServerCertFileName() + " " + CertUtils.getConfiguredServerKeyFileName() + " " + CertUtils.getConfiguredSigningChainFileName() + " " + CertUtils.getConfiguredArchivedServerCertFileName() + " " + CertUtils.getConfiguredArchivedServerKeyFileName() + " " + CertUtils.getConfiguredArchivedSigningChainFileName() + " " + hTTPDExecutable + " " + hTTPDPIDFile + " " + hMCSSLConfigFile + " " + hTTPDServerRoot;
        if (chainingFileName != null) {
            command = command + " " + chainingFileName;
        }
        CertUtils.executeCommand(command);
    }

    static synchronized void archiveAndDelete(ServerCert certificate) throws HException {
        ServerCert tempCertificate = null;
        String hTTPDExecutable = null;
        String hTTPDPIDFile = null;
        String hMCSSLConfigFile = null;
        String hTTPDServerRoot = null;
        try {
            hTTPDExecutable = CertUtils.getFQFileName("httpd");
            hTTPDPIDFile = CertUtils.getFQFileName("httpd.pid");
            hMCSSLConfigFile = CertUtils.getFQFileName("hmc_ssl.conf");
            hTTPDServerRoot = BaseFileControl.getFilePath("httpdServerRootDir");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        try {
            tempCertificate = new ServerCert(CertUtils.getConfiguredServerCertFileName());
        }
        catch (FileNotFoundException e) {
            throw new HException("Certificate requested to be deleted does not exist.");
        }
        if (!tempCertificate.equalsSomewhat(certificate)) {
            throw new HException("Certificate requested to be deleted does not match that currently being used.");
        }
        CertUtils.executeCommand("deleteCert " + CertUtils.getConfiguredServerCertFileName() + " " + CertUtils.getConfiguredServerKeyFileName() + " " + CertUtils.getConfiguredSigningChainFileName() + " " + CertUtils.getConfiguredArchivedServerCertFileName() + " " + CertUtils.getConfiguredArchivedServerKeyFileName() + " " + CertUtils.getConfiguredArchivedSigningChainFileName() + " " + hTTPDExecutable + " " + hTTPDPIDFile + " " + hMCSSLConfigFile + " " + hTTPDServerRoot);
    }

    static int wholeDaysGreater(Date firstTime, Date secondTime) throws HException {
        GregorianCalendar firstCalendar = null;
        GregorianCalendar secondCalendar = null;
        GregorianCalendar secondCalendarPlusRough = null;
        GregorianCalendar secondCalendarPlusRoughPlusOne = null;
        long milliSecondsGreater = 0L;
        long roughFullDaysLong = 0L;
        int roughFullDays = 0;
        int result = 0;
        Trace.trace(TRACE_MASKT, "->wholeDaysGreater(" + firstTime + ", " + secondTime + ")");
        milliSecondsGreater = firstTime.getTime() - secondTime.getTime();
        if (milliSecondsGreater <= 0L) {
            result = 0;
        } else {
            roughFullDaysLong = milliSecondsGreater / 86400000L;
            if (roughFullDaysLong + 1L > Integer.MAX_VALUE) {
                throw new HException("The number of days between the two dates is too large.");
            }
            roughFullDays = (int)roughFullDaysLong;
            firstCalendar = new GregorianCalendar();
            firstCalendar.setTimeInMillis(firstTime.getTime());
            secondCalendar = new GregorianCalendar();
            secondCalendar.setTimeInMillis(secondTime.getTime());
            secondCalendarPlusRough = secondCalendar;
            secondCalendarPlusRough.add(5, roughFullDays);
            secondCalendarPlusRoughPlusOne = secondCalendar;
            secondCalendarPlusRoughPlusOne.add(5, roughFullDays + 1);
            result = secondCalendarPlusRoughPlusOne.getTimeInMillis() > firstTime.getTime() ? (secondCalendarPlusRough.getTimeInMillis() <= firstTime.getTime() ? roughFullDays : roughFullDays - 1) : roughFullDays + 1;
        }
        Trace.trace(TRACE_MASKT, "<-wholeDaysGreater(...) returning " + result);
        return result;
    }

    static ArrayList getRemovableMediaDevices() throws MediaDeviceException {
        int i;
        ArrayList<RemovableMediaDevice> result = null;
        MediaDeviceIdentifier[] disketteDevices = null;
        MediaDeviceIdentifier[] dvdRAMDevices = null;
        MediaDeviceIdentifier currentDevice = null;
        result = new ArrayList<RemovableMediaDevice>();
        disketteDevices = MediaServices.getMediaServices().getMediaDeviceIdentifiers(1);
        for (i = 0; i < disketteDevices.length; ++i) {
            currentDevice = disketteDevices[i];
            if (currentDevice == null) continue;
            result.add(new RemovableMediaDevice(currentDevice.getDisplayableDeviceDescription(), currentDevice.getInternalDeviceName()));
        }
        dvdRAMDevices = MediaServices.getMediaServices().getMediaDeviceIdentifiers(3);
        for (i = 0; i < dvdRAMDevices.length; ++i) {
            currentDevice = dvdRAMDevices[i];
            if (currentDevice == null) continue;
            result.add(new RemovableMediaDevice(currentDevice.getDisplayableDeviceDescription(), currentDevice.getInternalDeviceName()));
        }
        return result;
    }

    private static synchronized ArrayList getX509Certificates(String fileName) {
        FileInputStream fis = null;
        CertificateFactory cf = null;
        X509Certificate cert = null;
        BufferedInputStream bis = null;
        ArrayList<X509Certificate> result = null;
        Trace.trace(TRACE_MASKF, "->getX509Certificates(" + fileName + ")");
        result = new ArrayList<X509Certificate>();
        try {
            fis = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "FileNotFoundException: " + e);
            return result;
        }
        bis = new BufferedInputStream(fis);
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            Trace.trace(TRACE_MASKF, "CertificateException: " + e);
            return result;
        }
        try {
            while (bis.available() > 0) {
                cert = (X509Certificate)cf.generateCertificate(bis);
                result.add(cert);
            }
            return result;
        }
        catch (CertificateException e) {
            Trace.trace(TRACE_MASKF, "CertificateException: " + e);
            return result;
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException: " + e);
            return result;
        }
    }

    private static synchronized ArrayList getX509SigningCertificates() throws HException {
        return CertUtils.getX509Certificates(CertUtils.getConfiguredSigningChainFileName());
    }

    private static synchronized ArrayList getArchivedX509SigningCertificates() throws HException {
        return CertUtils.getX509Certificates(CertUtils.getConfiguredArchivedSigningChainFileName());
    }

    static synchronized X509Certificate findArchivedX509SigningCertificate(CertPrincipal issuer) throws HException {
        ArrayList certificates = null;
        X509Certificate certificate = null;
        X509Certificate result = null;
        X500Principal currentIssuer = null;
        certificates = CertUtils.getArchivedX509SigningCertificates();
        Iterator i = certificates.iterator();
        while (i.hasNext()) {
            certificate = (X509Certificate)i.next();
            currentIssuer = certificate.getIssuerX500Principal();
            if (currentIssuer == null || !new CertPrincipal(currentIssuer).equals(issuer)) continue;
            result = certificate;
            break;
        }
        return result;
    }

    static synchronized X509Certificate findX509SigningCertificate(CertPrincipal issuer) throws HException {
        ArrayList certificates = null;
        X509Certificate certificate = null;
        X509Certificate result = null;
        X500Principal currentIssuer = null;
        certificates = CertUtils.getX509SigningCertificates();
        Iterator i = certificates.iterator();
        while (i.hasNext()) {
            certificate = (X509Certificate)i.next();
            currentIssuer = certificate.getIssuerX500Principal();
            if (currentIssuer == null || !new CertPrincipal(currentIssuer).equals(issuer)) continue;
            result = certificate;
            break;
        }
        return result;
    }

    static String getSavedKeyFileName() {
        String pendingKeyFile = null;
        try {
            pendingKeyFile = BaseFileControl.getFilePath(SSL_KEY_DIR) + "pending.server.key";
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
        }
        return pendingKeyFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static File concatenateCerts(String[] certFileNames) throws HException {
        String tempFileName = null;
        File tempFile = null;
        StringBuffer fileNamesBuf = null;
        boolean resultValid = false;
        File tempDir = null;
        String tempDirName = null;
        try {
            tempDirName = BaseFileControl.getFilePath("tmp");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        tempDir = new File(tempDirName);
        try {
            try {
                tempFile = File.createTempFile(TRACE_MASKT, null, tempDir);
                tempFileName = tempFile.getCanonicalPath();
                if (certFileNames != null && certFileNames.length > 0) {
                    fileNamesBuf = new StringBuffer();
                    for (int i = 0; i < certFileNames.length; ++i) {
                        fileNamesBuf.append(certFileNames[i]);
                        fileNamesBuf.append(" ");
                    }
                    CertUtils.executeCommand("cat " + fileNamesBuf.toString() + "> " + tempFileName);
                    resultValid = true;
                }
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKD, "IOException caught concatenating certificates: " + e);
                throw new HException(e);
            }
            Object var9_10 = null;
            if (tempFile == null) return tempFile;
            if (resultValid) return tempFile;
            tempFile.delete();
            return null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (tempFile == null) throw throwable;
            if (resultValid) throw throwable;
            tempFile.delete();
            tempFile = null;
            throw throwable;
        }
    }

    static void appendPropertyValue(String propertyName, String value, StringBuffer buffer) {
        if (value != null && value.length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(propertyName);
            buffer.append('=');
            buffer.append(value);
        }
    }

    static String getRandomString() {
        StringBuffer result = null;
        byte[] tempPassPhraseArray = null;
        result = new StringBuffer();
        tempPassPhraseArray = new byte[8];
        new SecureRandom().nextBytes(tempPassPhraseArray);
        for (int i = 0; i < tempPassPhraseArray.length; ++i) {
            result.append(Byte.toString(tempPassPhraseArray[i]));
        }
        return result.toString();
    }
}

